
IF  not EXISTS (SELECT * FROM sys.tables WHERE name='GLB_OPER_CEL')
begin 
 
CREATE TABLE [dbo].[GLB_OPER_CEL](
	[CD_EMP] [int] NOT NULL,
	[CD_OPER_CEL] [int] NOT NULL,
	[NM_OPER_CEL] [varchar](50) NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[DT_ULT_ATU] [datetime] NULL,
	[NR_OPER_CEL] [int] NOT NULL,
	[CD_FORN] [int] NULL,
	[PERC_COMIS] [money] NOT NULL,
	[GLB_OPER_CEL] [int] NOT NULL,
 CONSTRAINT [PK_GLB_OPER_CEL] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_OPER_CEL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY],
 CONSTRAINT [IX_GLB_OPER_CEL] UNIQUE NONCLUSTERED 
(
	[NM_OPER_CEL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY],
 CONSTRAINT [IX_GLB_OPER_CEL_1] UNIQUE NONCLUSTERED 
(
	[NR_OPER_CEL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]

 

ALTER TABLE [dbo].[GLB_OPER_CEL] ADD  CONSTRAINT [DF_GLB_OPER_CEL_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]
 

ALTER TABLE [dbo].[GLB_OPER_CEL] ADD  CONSTRAINT [DF_GLB_OPER_CEL_CD_OPER_CEL]  DEFAULT ((0)) FOR [CD_OPER_CEL]
 

ALTER TABLE [dbo].[GLB_OPER_CEL] ADD  CONSTRAINT [DF_GLB_OPER_CEL_NM_OPER_CEL]  DEFAULT ('') FOR [NM_OPER_CEL]
 

ALTER TABLE [dbo].[GLB_OPER_CEL] ADD  CONSTRAINT [DF_GLB_OPER_CEL_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]
 

ALTER TABLE [dbo].[GLB_OPER_CEL] ADD  CONSTRAINT [DF_GLB_OPER_CEL_CD_USU]  DEFAULT ((0)) FOR [CD_USU]
 

ALTER TABLE [dbo].[GLB_OPER_CEL] ADD  CONSTRAINT [DF_GLB_OPER_CEL_NR_OPER_CEL_1]  DEFAULT ((0)) FOR [NR_OPER_CEL]
 

ALTER TABLE [dbo].[GLB_OPER_CEL] ADD  CONSTRAINT [DF_GLB_OPER_CEL_PERC_COMIS]  DEFAULT ((0)) FOR [PERC_COMIS]
 

ALTER TABLE [dbo].[GLB_OPER_CEL] ADD  DEFAULT ((0)) FOR [GLB_OPER_CEL]
 

ALTER TABLE [dbo].[GLB_OPER_CEL]  WITH CHECK ADD  CONSTRAINT [FK_GLB_OPER_CEL_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])
ON UPDATE CASCADE
 

ALTER TABLE [dbo].[GLB_OPER_CEL] CHECK CONSTRAINT [FK_GLB_OPER_CEL_EST_PROD]
 

ALTER TABLE [dbo].[GLB_OPER_CEL]  WITH CHECK ADD  CONSTRAINT [FK_GLB_OPER_CEL_GLB_USU] FOREIGN KEY([CD_USU])
REFERENCES [dbo].[GLB_USU] ([CD_USU])
ON UPDATE CASCADE
 

ALTER TABLE [dbo].[GLB_OPER_CEL] CHECK CONSTRAINT [FK_GLB_OPER_CEL_GLB_USU]
 

ALTER TABLE [dbo].[GLB_OPER_CEL]  WITH CHECK ADD  CONSTRAINT [GLB_OPER_CEL_PG_FORN_FK] FOREIGN KEY([CD_EMP], [CD_FORN])
REFERENCES [dbo].[PG_FORN] ([CD_EMP], [CD_FORN])
 

ALTER TABLE [dbo].[GLB_OPER_CEL] CHECK CONSTRAINT [GLB_OPER_CEL_PG_FORN_FK]
 


end